/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.rss;

import data.base.Database;
import data.base.NoBaseException;
import data.base.connectors.RSSFeedDatabase;
import data.structures.tagging.GraphLemmaItem;
import data.structures.tagging.LemmaItem;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Vector;

public class RSSGraph {
    private Database theDB;
    private GraphLemmaItem node;

    public RSSGraph(Database db){
        theDB = db;
    }

    public void setNode(int id){
        GraphLemmaItem graph_item = new GraphLemmaItem();
        try {
            RSSFeedDatabase rss_db = new RSSFeedDatabase(theDB);
            RSSItem rss_item = rss_db.getRssItem(id);
            graph_item.setNodeID(id);
            graph_item.setNodeName(rss_item.getTitle());
            Set<LemmaItem> lemmas = rss_db.getLemmas(id);
            Vector<LemmaItem> lemmes = new Vector<LemmaItem>(lemmas);
            //Elimination des lemmes non substantifs
            for(int i=0; i<lemmes.size(); i++){
                String type = lemmes.elementAt(i).getLemmaLex();
                if(!(type.equalsIgnoreCase("NOM") && !(type.equalsIgnoreCase("NAM")))){
                    lemmes.removeElementAt(i);
                    i--;
                }
            }
            graph_item.setLemmas(new LinkedHashSet<LemmaItem>(lemmes));
            node = graph_item;
        } catch(NoBaseException nbe){
        }
    }
    
    public GraphLemmaItem getNode(){
        return node;
    }
    
}
